/**
Excel-Spalten Zuordnungstabelle:
  A |  B |  C |  D |  E |  F |  G |  H |  I |  J |  K |  L |  M |  N |  O |  P |  Q |  R |  S |  T |  U |  V |  W |  X |  Y |  Z |
  0 |  1 |  2 |  3 |  4 |  5 |  6 |  7 |  8 |  9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 | 25 |
  
 AA | AB | AC | AD | AE | AF | AG | AH | AI | AJ | AK | AL | AM | AN | AO | AP | AQ | AR | AS | AT | AU | AV | AW | AX | AY | AZ |
 26 | 27 | 28 | 29 | 30 | 31 | 32 | 33 | 34 | 35 | 36 | 37 | 38 | 39 | 40 | 41 | 42 | 43 | 44 | 45 | 46 | 47 | 48 | 49 | 50 | 51 |
 
 BA | BB | BC | BD | BE | BF | BG | BH | BI | BJ | BK | BL | BM | BN | BO | BP | BQ | BR | BS | BT | BU | BV | BW | BX | BY | BZ |
 52 | 53 | 54 | 55 | 56 | 57 | 58 | 59 | 60 | 61 | 62 | 63 | 64 | 65 | 66 | 67 | 68 | 69 | 70 | 71 | 72 | 73 | 74 | 75 | 76 | 77 |

var config = {
	diagrams: [
		// 1
		{
			title: "Bruttoinlandsprodukt in den EU-Staaten seit Vollendung des EU-Binnenmarktes (1993-2016)",
			column_xAxis: 0, // Spalten-Nr. A
			label_xAxis: "Jahr",
			label_yAxis: "US-Dollar in Billionen",
			unitScaleFactor: 1/1000000000000,			// [optional] default: 1, Skalierungfaktor für die Y-Werte, auch als Divisor verwendbar (z.B. für dia Angabe in Tausend 1/1000)
			yAxis_numberOfDigitsAfterDecimalPoint: 2,	// [optional] default: 0, Anzahl der Dezimalstellen
			ml_htmlLegend_numberOfColumns: 2,			// [optional] default: 1, HTMLLegende kann mehrspaltig angezeigt werden
			ml_htmlLegend_numberOfColumns_rwd: {'xs':1, 'sm':2, 'md':3, 'lg':4},			// [optional], HTMLLegende mehrspaltig (RWD) abhängig von viewport-Größe
			rangeSlider_hidden: true,					// [optional] default: false, Range-Slider zeigen/verstecken
			ml_tooltip_legendTitlePosition: 'none',		// [optional] default: 'none', Position des Legenden-Titels im Tooltip. Werte: 'none', 'head', 'body'
			ml_tooltip_legendTitleSuffix: ': ',			// [optional] default: '<br>', Markup oder Text, der hinter den Legenden-Titel angefügt wird
			ml_tooltip_valueSuffix: '&nbsp;%',			// [optional] default: '', Markup oder Text, der hinter den y-Wert angefügt wird
			ml_tooltip_mode: 'index',					// [optional] default: 'nearest', Die Art wie Werte im Tooltip angezeigt werden. 'index': alle y-Werte aller sichtbaren datasets
														// siehe http://www.chartjs.org/docs/latest/general/interactions/modes.html
			ml_tooltip_widthScaleFactor_rwd: {'xs':0.5, 'sm':0.5, 'md':0.33, 'lg':0.33},	// [optional], Skalierungsfaktor für die Tooltip-Breite in Bezug auf den Chart-Container (panel)
			ml_yAxis_dynamicScaling: false,				// [optional] default: false, Y-Achsen-Skala wird dynamisch verändert, je nach Werten
			ml_yAxis_maxValue: undefined,				// [optional] default: undefined, @type:number, Y-Achse: Maximal-Wert
			ml_xAxis_autoSkip: true,					// [optional] default: true, X-Achsen-Skala wird dynamisch verändert bzw. werden Werte ausgelassen, je nachdem wieviel Platz zur Verfügung steht (@since 1.4.0)
			charts: [
				{
					// Belgien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 1, // Spalten-Nr. B
					hidden: false
				},
				{
					// Deutschland
					type: "line", // Werte: "line" || "bar"
					column_yValues: 2, // Spalten-Nr. C
					hidden: true
				}
			]
		}
	],
	colors: [														// es müssen mindestenst so viele Farbwerte angegeben werden, wie die max. Anzahl charts, die in einem Diagramm dargestellt werden sollen
		{
			backgroundColor:	'#feff41', 
			borderColor:		'#feff41'
		},
		{
			backgroundColor:	'#fed22b', 
			borderColor:		'#fed22b'
		},
		{
			backgroundColor:	'#fea817', 
			borderColor:		'#fea817'
		}
	],
	watchmode: 'single'												// [optional] Werte: 'compare' (default) || 'single'
	watchmode_resetOnToggle: false,									// [optional] Werte: true (default) || false, setzt alle SelectionMenues zurück, wenn zwischen den Anzeige-Modi ("single" und "compare") umgeschaltet wird
	watchmode_openFirstAvailableChartOnCompareMode: true,			// [optional] Werte: true || false (default), öffnet bei Wahl des Vergleichsmodus automatisch die nächste zur Verfügung stehende Chart im 2. Select-Menü (watchmode_resetOnToggle muss false sein!)
	ml_pointRadius_rwd: {'xs':2, 'sm':3, 'md':4, 'lg':5},			// [optional] Punktradius bei Linien-Diagrammen (RWD),
	ml_label_fontStyle: 'normal',									// [optional] default: 'normal', @type:string, Schrift-Stil der Achsen-Beschriftung. Werte: 'normal', 'bold', 'italic', 'oblique'
	ml_label_fontSize: undefined									// [optional] default: undefined, @type:number, Schriftgröße der Achsen-Beschriftung
};
*/

var config = {
	diagrams: [
		// 1
		{
			title: "Gehalts- und Lohnkosten der Länder der Europäischen Union (durchschnittlich, in Euro/Stunde)",
			column_xAxis: 0, // Spalten-Nr. A
			label_xAxis: "Jahr",
			label_yAxis: "Euro/Stunde",
			unitScaleFactor: 1, // default: 1
			yAxis_numberOfDigitsAfterDecimalPoint: 1,
			//ml_htmlLegend_numberOfColumns: 3,
			ml_htmlLegend_numberOfColumns_rwd: {'xs':2, 'sm':2, 'md':3, 'lg':4},
			ml_tooltip_legendTitlePosition: 'body',
			ml_tooltip_legendTitleSuffix: ': ',
			ml_tooltip_valueSuffix: '&nbsp;€/h',
			ml_tooltip_widthScaleFactor_rwd: {'xs':0.55, 'sm':0.55, 'md':0.40, 'lg':0.40},
			ml_yAxis_dynamicScaling: true,
			charts: [
				{
					// Dänemark
					type: "line", // Werte: "line" || "bar"
					column_yValues: 1, // Spalten-Nr. B
					hidden: false
				},
				{
					// Luxemburg
					type: "line", // Werte: "line" || "bar"
					column_yValues: 2, // Spalten-Nr. C
					hidden: true
				},
				{
					// Belgien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 3, // Spalten-Nr. D
					hidden: true
				},
				{
					// Irland
					type: "line", // Werte: "line" || "bar"
					column_yValues: 4, // Spalten-Nr. E
					hidden: true
				},
				{
					// Niederlande
					type: "line", // Werte: "line" || "bar"
					column_yValues: 5, // Spalten-Nr. F
					hidden: true
				},
				{
					// Deutschland
					type: "line", // Werte: "line" || "bar"
					column_yValues: 6, // Spalten-Nr. G
					hidden: true
				},
				{
					// Finnland
					type: "line", // Werte: "line" || "bar"
					column_yValues: 7, // Spalten-Nr. H
					hidden: true
				},
				{
					// Österreich
					type: "line", // Werte: "line" || "bar"
					column_yValues: 8, // Spalten-Nr. I
					hidden: true
				},
				{
					// Schweden
					type: "line", // Werte: "line" || "bar"
					column_yValues: 9, // Spalten-Nr. J
					hidden: true
				},
				{
					// Frankreich
					type: "line", // Werte: "line" || "bar"
					column_yValues: 10, // Spalten-Nr. K
					hidden: true
				},
				{
					// EU-27
					type: "line", // Werte: "line" || "bar"
					column_yValues: 11, // Spalten-Nr. L
					hidden: true
				},
				{
					// Italien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 12, // Spalten-Nr. M
					hidden: true
				},
				{
					// Slowenien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 13, // Spalten-Nr. N
					hidden: true
				},
				{
					// Spanien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 14, // Spalten-Nr. O
					hidden: true
				},
				{
					// Malte
					type: "line", // Werte: "line" || "bar"
					column_yValues: 15, // Spalten-Nr. P
					hidden: true
				},
				{
					// Griechenland
					type: "line", // Werte: "line" || "bar"
					column_yValues: 16, // Spalten-Nr. Q
					hidden: true
				},
				{
					// Portugal
					type: "line", // Werte: "line" || "bar"
					column_yValues: 17, // Spalten-Nr. R
					hidden: true
				},
				{
					// Tschechien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 18, // Spalten-Nr. S
					hidden: true
				},
				{
					// Litauen
					type: "line", // Werte: "line" || "bar"
					column_yValues: 19, // Spalten-Nr. T
					hidden: true
				},
				{
					// Estland
					type: "line", // Werte: "line" || "bar"
					column_yValues: 20, // Spalten-Nr. U
					hidden: true
				},
				{
					// Slowakei
					type: "line", // Werte: "line" || "bar"
					column_yValues: 21, // Spalten-Nr. V
					hidden: true
				},
				{
					// Kroatien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 22, // Spalten-Nr. W
					hidden: true
				},
				{
					// Polen
					type: "line", // Werte: "line" || "bar"
					column_yValues: 23, // Spalten-Nr. X
					hidden: true
				},
				{
					// Lettland
					type: "line", // Werte: "line" || "bar"
					column_yValues: 24, // Spalten-Nr. Y
					hidden: true
				},
				{
					// Ungarn
					type: "line", // Werte: "line" || "bar"
					column_yValues: 25, // Spalten-Nr. Z
					hidden: true
				},
				{
					// Rumänien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 26, // Spalten-Nr. AA
					hidden: true
				},
				{
					// Serbien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 27, // Spalten-Nr. AB
					hidden: true
				},
				{
					// Bulgarien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 28, // Spalten-Nr. AC
					hidden: true
				}
			]
		},
		// 2
		{
			title: "Ausländische Investitionszuflüsse (in Mrd. US-Dollar) nach Weltregionen",
			column_xAxis: 29, // Spalten-Nr. AD
			label_xAxis: "Jahr",
			label_yAxis: "US Dollar in Mrd.",
			unitScaleFactor: 1, // default: 1
			yAxis_numberOfDigitsAfterDecimalPoint: 1,
			//ml_htmlLegend_numberOfColumns: 3,
			ml_htmlLegend_numberOfColumns_rwd: {'xs':2, 'sm':2, 'md':3, 'lg':4},
			ml_tooltip_legendTitlePosition: 'body',
			ml_tooltip_legendTitleSuffix: ': ',
			ml_tooltip_valueSuffix: '&nbsp;Mrd.&nbsp;$',
			ml_tooltip_widthScaleFactor_rwd: {'xs':0.55, 'sm':0.55, 'md':0.40, 'lg':0.40},
			ml_yAxis_dynamicScaling: true,
			charts: [
				{
					// Afrika
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 30, // Spalten-Nr. AE
					hidden: false,
					backgroundColor:	'#7fcfee', // männlich
					borderColor:		'#7fcfee'  // männlich
				},
				{
					// Nordamerika
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 31, // Spalten-Nr. AF
					hidden: false,
					backgroundColor:	'rgb(225, 0, 123)', // weiblich
					borderColor:		'rgb(225, 0, 123)'  // weiblich
				},
				{
					// Entwicklungsländer in Asien
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 32, // Spalten-Nr. AG
					hidden: false,
					backgroundColor:	'rgb(255, 213, 49)', // gesamt
					borderColor:		'rgb(255, 213, 49)'  // gesamt
				},
				{
					// Europa
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 33, // Spalten-Nr. AH
					hidden: false,
					backgroundColor:	'#7d5390',
					borderColor:		'#7d5390'
				}
			]
		},
		// 3
		{
			title: "Ausländische Investitionszuflüsse (in Mrd. US-Dollar) nach Ländern",
			column_xAxis: 34, // Spalten-Nr. AI
			label_xAxis: "Jahr",
			label_yAxis: "US Dollar in Mrd.",
			unitScaleFactor: 1, // default: 1
			yAxis_numberOfDigitsAfterDecimalPoint: 1,
			//ml_htmlLegend_numberOfColumns: 3,
			ml_htmlLegend_numberOfColumns_rwd: {'xs':2, 'sm':2, 'md':3, 'lg':4},
			ml_tooltip_legendTitlePosition: 'body',
			ml_tooltip_legendTitleSuffix: ': ',
			ml_tooltip_valueSuffix: '&nbsp;Mrd.&nbsp;$',
			ml_tooltip_widthScaleFactor_rwd: {'xs':0.55, 'sm':0.55, 'md':0.40, 'lg':0.40},
			ml_yAxis_dynamicScaling: true,
			charts: [
				{
					// USA
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 35, // Spalten-Nr. AJ
					hidden: false,
					backgroundColor:	'#7fcfee', // männlich
					borderColor:		'#7fcfee'  // männlich
				},
				{
					// China
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 36, // Spalten-Nr. AK
					hidden: false,
					backgroundColor:	'rgb(225, 0, 123)', // weiblich
					borderColor:		'rgb(225, 0, 123)'  // weiblich
				},
				{
					// Deutschland
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 37, // Spalten-Nr. AL
					hidden: false,
					backgroundColor:	'rgb(255, 213, 49)', // gesamt
					borderColor:		'rgb(255, 213, 49)'  // gesamt
				},
				{
					// Indien
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 38, // Spalten-Nr. AM
					hidden: false,
					backgroundColor:	'#7d5390',
					borderColor:		'#7d5390'
				},
				{
					// Mexiko
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 39, // Spalten-Nr. AN
					hidden: false,
					backgroundColor:	'#e30613',
					borderColor:		'#e30613'
				}
			]
		},
		// 4
		{
			title: "Zu- und Abwanderung im Jahr 2020 (in Tausend)",
			column_xAxis: 40, // Spalten-Nr. AO
			label_xAxis: "Länder",
			label_yAxis: "Zu- und Abwanderung in Tausend",
			unitScaleFactor: 1, // default: 1
			yAxis_numberOfDigitsAfterDecimalPoint: 3,
			//ml_htmlLegend_numberOfColumns: 3,
			ml_htmlLegend_numberOfColumns_rwd: {'xs':2, 'sm':2, 'md':3, 'lg':4},
			ml_tooltip_legendTitlePosition: 'body',
			ml_tooltip_legendTitleSuffix: ': ',
			ml_tooltip_valueSuffix: '&nbsp;Mrd.&nbsp;$',
			ml_tooltip_widthScaleFactor_rwd: {'xs':0.55, 'sm':0.55, 'md':0.40, 'lg':0.40},
			ml_yAxis_dynamicScaling: true,
			charts: [
				{
					// Zuwanderung
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 41, // Spalten-Nr. AP
					hidden: false,
					backgroundColor:	'rgb(225, 0, 123)', // weiblich
					borderColor:		'rgb(225, 0, 123)'  // weiblich
				},
				{
					// Abwanderung
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 42, // Spalten-Nr. AQ
					hidden: false,
					backgroundColor:	'#7fcfee', // männlich
					borderColor:		'#7fcfee'  // männlich
				}
			]
		}
	],
	colors: [
//		{
//			backgroundColor:	'#7fcfee', // männlich
//			borderColor:		'#7fcfee'  // männlich
//		},
//		{
//			backgroundColor:	'rgb(225, 0, 123)', // weiblich
//			borderColor:		'rgb(225, 0, 123)'  // weiblich
//		},
//		{
//			backgroundColor:	'rgb(255, 213, 49)', // gesamt
//			borderColor:		'rgb(255, 213, 49)'  // gesamt
//		},
		// 1 - 5
		{
			backgroundColor:	'#e30613', 
			borderColor:		'#e30613'
		},
		{
			backgroundColor:	'#1c1c1b', 
			borderColor:		'#1c1c1b'
		},
		{
			backgroundColor:	'#86bc24', 
			borderColor:		'#86bc24'
		},
		{
			backgroundColor:	'#f6d800', 
			borderColor:		'#f6d800'
		},
		{
			backgroundColor:	'#e4007d', 
			borderColor:		'#e4007d'
		},
		// 6 - 10
		{
			backgroundColor:	'#224880', 
			borderColor:		'#224880'
		},
		{
			backgroundColor:	'#50b4c0', 
			borderColor:		'#50b4c0'
		},
		{
			backgroundColor:	'#4c913f', 
			borderColor:		'#4c913f'
		},
		{
			backgroundColor:	'#1e4670', 
			borderColor:		'#1e4670'
		},
		{
			backgroundColor:	'#9b6b08', 
			borderColor:		'#9b6b08'
		},
		// 11 - 15
		{
			backgroundColor:	'#512981', 
			borderColor:		'#512981'
		},
		{
			backgroundColor:	'#e16b0a', 
			borderColor:		'#e16b0a'
		},
		{
			backgroundColor:	'#2a529e', 
			borderColor:		'#2a529e'
		},
		{
			backgroundColor:	'#f18802', 
			borderColor:		'#f18802'
		},
		{
			backgroundColor:	'#f06b2e', 
			borderColor:		'#f06b2e'
		},
		// 16 - 20
		{
			backgroundColor:	'#f29707', 
			borderColor:		'#f29707'
		},
		{
			backgroundColor:	'#cc3332', 
			borderColor:		'#cc3332'
		},
		{
			backgroundColor:	'#5f5f5f', 
			borderColor:		'#5f5f5f'
		},
		{
			backgroundColor:	'#f1c019', 
			borderColor:		'#f1c019'
		},
		{
			backgroundColor:	'#418dcd', 
			borderColor:		'#418dcd'
		},
		// 21 - 25
		{
			backgroundColor:	'#2f758b', 
			borderColor:		'#2f758b'
		},
		{
			backgroundColor:	'#5bccff', 
			borderColor:		'#5bccff'
		},
		{
			backgroundColor:	'#2e5da5', 
			borderColor:		'#2e5da5'
		},
		{
			backgroundColor:	'#a5be00', 
			borderColor:		'#a5be00'
		},
		{
			backgroundColor:	'#3866cd', 
			borderColor:		'#3866cd'
		},
		// 26 - 30
		{
			backgroundColor:	'#f29905', 
			borderColor:		'#f29905'
		},
		{
			backgroundColor:	'#981536', 
			borderColor:		'#981536'
		},
		{
			backgroundColor:	'#599cd3', 
			borderColor:		'#599cd3'
		},
		{
			backgroundColor:	'#265488', 
			borderColor:		'#265488'
		},
		{
			backgroundColor:	'#b70e0b', 
			borderColor:		'#b70e0b'
		}
	],
	watchmode: 'single', // Werte: 'single' || 'compare'
	watchmode_resetOnToggle: false, // Werte: true (default) || false
	watchmode_openFirstAvailableChartOnCompareMode: false, // Werte: true || false (default); watchmode_resetOnToggle muss false sein!
	watchmode_resetAlwaysOnSingleMode: true, // default: true
	ml_pointRadius_rwd: {'xs':2, 'sm':3, 'md':4, 'lg':5},
	ml_label_fontStyle: 'bold' // [optional] default: 'normal', @type:string, Schrift-Stil der Achsen-Beschriftung. Werte: 'normal', 'bold', 'italic', 'oblique'
};