/**
 * NumberThousandsFormatter
 * 
 * @author Matthias Schulz
 * @static
 * @class NumberThousandsFormatter
 * @namespace ML_APP.CONTENT.CLASSES.exams
 * @copyright ModernLearning GmbH
 * @version 1.0.1
 */
(function() {
	var _lib = ML_APP.lib;
	
	/** @private */
	var ns = ML_APP.lib.getNamespace( 'ML_APP.CLASSES.Math' );
	
	var _debug_str;
	var _hasNegativeSign = false;
	var _debugging = false;
	var _useNegativeSign = true;
	
	/**
	 * Constructor
	 */
	function NumberThousandsFormatter() {
		// lehrer Konstruktor
	}
	
	/**
	 * 
	 * @param {String} test_str					Der Ausgangsstring, in den ein Trennzeichen eingefügt werden soll (z.B. "1000000")
	 * @param {String} eingefuegteszeichen		Das Trennzeichen, das eingefügt werden soll (z.B. "." oder ",");
	 * @param {Number} abstand					Der Abstand zwischen den Trennzeichen (z.B. bei abstand = 3  =>   "1.000.000" )
	 * @returns {String}						Der modifizierte String.
	 */
	NumberThousandsFormatter.format = function( test_str, eingefuegteszeichen, abstand ) {
		_debug_str = "";
		
		// nur wenn das tausender Trennzeichen noch nicht eingefügt wurde
		if (test_str.indexOf(eingefuegteszeichen) === -1) {
			_debug_str += "Ursprünglicher String: " + test_str + "\n";
			
			// Whitespace entfernen
			test_str = this._searchReplaceString( test_str, " ", "" );
			
			// Testen auf "-" (Minus-Zeichen), es darf nur ein einziges geben, unzwar am Amfang
			// alle weiteren Minus-Zeichen entfernen
			if (_useNegativeSign) {
				// nach "-" am Anfang suchen
				if (test_str.indexOf("-") === 0) {
					_hasNegativeSign = true;
				} else {
					_hasNegativeSign = false;
				}
			}
			// alle "-" entfernen
			test_str = this._searchReplaceString( test_str, "-", "" );
			
			// Dezimalstellen entfernen und zwischenspeichern
			var dezTeilstr_str /*:String*/ = "";
			var posKomma /*:Number*/ = test_str.indexOf( "," );
			
			if (posKomma !== -1) {
					_debug_str += "Position des Kommas: " + posKomma + "\n";
				
				dezTeilstr_str = test_str.substring( posKomma, test_str.length );
					_debug_str += "Dezimalteil: " + dezTeilstr_str + "\n";
				test_str = test_str.slice( 0, posKomma );
					_debug_str += "Zahl ohne Dezimalteil: " + test_str + "\n";
			}
			
			// Stringlänge ermitteln
			var strlaenge = test_str.length;
				_debug_str += "Länge des Strings: " + strlaenge + "\n";
			// Abfrage, ob überhaupt ein Trennzeichen benötigt wird
			if (strlaenge > abstand) {
				// Anzahl, wie oft ein Teilstring ermittelt werden muss
				var anzahlschleifendurchgaenge = Math.floor( strlaenge/abstand );
					_debug_str += "Länge des Teiles, das Trennzeichen bekommt: " + anzahlschleifendurchgaenge*abstand + "\n";
				// Ist die String-Länge ein Vielfaches des Abstandes...
				var pos1 = strlaenge % abstand;
					_debug_str += "Länge des Teiles, das nicht dem 'abstand' entspricht: " + pos1 + "\n";
				// Wenn nein...
				if (pos1 !== 0) {
					var teilstr0_str = test_str.substr( 0, pos1 );
						_debug_str += "Teilstring 0: " + teilstr0_str + "\n";
					// Der Teil des Strings, der nicht "abstand" Zeichen enthält
					teilstr0_str += eingefuegteszeichen;
					// Der restliche Teil des Strings, der ein Vielfaches des Abstands an Zeichen hat
					var tripel_str = test_str.substr( pos1, anzahlschleifendurchgaenge*abstand );
						_debug_str += "Die Zeichenkette, die Trennzeichen bekommen soll: " + tripel_str + "\n";
					var zaehler = 0;
					var teilstr /*:Array*/ = [];
					ergebnis_str = "";
					for (var i=1; i<=anzahlschleifendurchgaenge; i++) {
						// Teilstrings werden erzeugt und hinter jeden Teilstring das Trennzeichen angehängt
						teilstr[i] = tripel_str.substr( zaehler, abstand) ;
						if (i<anzahlschleifendurchgaenge) {
						  teilstr[i] += eingefuegteszeichen;
						}
							_debug_str += "Teilstring " + i + ": " + teilstr[i] + "\n";
						zaehler += abstand;
						ergebnis_str += teilstr[i];
					}
					// Teilstringe wieder zusammen setzen
					ergebnis_str = teilstr0_str.concat(ergebnis_str) + dezTeilstr_str;
						_debug_str += "Ergebnis-String: " + ergebnis_str + "\n";
					
					if (_hasNegativeSign) {
						ergebnis_str = "-" + ergebnis_str;
					}
					
					if (_debugging) {
						console.log(_debug_str);
					}
					
					return ergebnis_str;
				} else // String-Länge ist Vielfaches von Abstand
				{
					// Der restliche Teil des Strings, der ein Vielfaches des Abstands an Zeichen hat
					tripel_str = test_str.substr( 0, anzahlschleifendurchgaenge*abstand );
						_debug_str += "Die Zeichenkette, die Trennzeichen bekommen soll: " + tripel_str + "\n";
					zaehler = 0;
					var teilstr/*:Array*/ = [];
					var ergebnis_str/*:String*/ = "";
					for (i=1; i<=anzahlschleifendurchgaenge; i++) {
						// Teilstrings in Länge des Abstandes werden erzeugt und das Trennzeichen hinten angefügt
						teilstr[i] = tripel_str.substr( zaehler, abstand );
						if (i<anzahlschleifendurchgaenge) {
						  teilstr[i] += eingefuegteszeichen;
						}
							_debug_str += "Teilstring " + i + ": " + teilstr[i] + "\n";
						zaehler += abstand;
						// Teilstrings werden erneut zusammen gefügt
						ergebnis_str += teilstr[i];
					}
					ergebnis_str += dezTeilstr_str;
						_debug_str += "Ergebnis-String: " + ergebnis_str + "\n";
					
					if (_hasNegativeSign) {
						ergebnis_str = "-" + ergebnis_str;
					}
					
					if (_debugging) {
						console.log(_debug_str);
					}
					
					return ergebnis_str;
				}
			}
			else
			{
				ergebnis_str = test_str + dezTeilstr_str;
				
				if (_hasNegativeSign) {
					ergebnis_str = "-" + ergebnis_str;
				}
				
				if (_debugging) {
					console.log(_debug_str);
				}
				
				return ergebnis_str;
			}
		} 
		else // Tausender Trennzeichen ist bereits vorhanden
		{
			return test_str;
		}
	};
	
	NumberThousandsFormatter.removeFormatting = function( str, eingefuegteszeichen ) {
		return this._searchReplaceString( str, eingefuegteszeichen, "" );
	};
	
	/**
	 * Durchsucht einen String nach einem Teilstring und ersetzt diesen durch einen benutzerdefinierten String.
	 * 
	 * @param {String} txt		Der zu durchsuchende Text.
	 * @param {String} find		Der zu findende Teilstring.
	 * @param {String} replace	Der ersetzende Teilstring.
	 * @returns {String}
	 */
	NumberThousandsFormatter._searchReplaceString = function( txt, find, replace ) {
		var txt = txt;
		var counter = 0;
		while (counter < txt.length) {
			var start = txt.indexOf( find, counter );
			if (start === -1) {
				break;
			} else {
				var before = txt.substr( 0, start );
				var after = txt.substr( start + find.length, txt.length );
				txt = before + replace + after;
				var counter = before.length + replace.length;
			}
		}
		return txt;
	};
	
	
	// Zuweisung zum Namespace-Object
	ns.NumberThousandsFormatter = NumberThousandsFormatter;
}());