var app = angular.module("spa", []);


app.controller("controller", function ($scope, $window) {

    $scope.introSkipped = false;
    $scope.activeQuestion = 0;
    $scope.mobile = false;
    $scope.score = 0;
    $scope.firstPartMessageReceived = false;
    $scope.scrolledIntoView = false;

    if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
        $scope.mobile= true;
       }

    $("#modalIntro").modal('show');

    $('.carousel').carousel({
        interval: false
      });

      $('#carousel').carousel('pause');

      $('#questionCarousel').on('slide.bs.carousel', function(ev) {
        setTimeout(function(){ 
             $scope.activeQuestion = ev.to;
             if (ev.to > 11 && ev.to <=14)
             {
                $scope.checkFirstPart();
             }
             $scope.$apply();
          }, 200);
         
    });

    maxBoxes = Math.floor(window.innerWidth / 54);
    if (maxBoxes % 2 == 0)
    {
        maxBoxes +=1;
    }

    $scope.checkFirstPart = function(){
        partDone = true;
        for (let i=0; i< 12;i++)
        {
            if($scope.questionaire[i].selected == false)
            {
                partDone = false;
            }
        }

        // if(partDone&&!$scope.firstPartMessageReceived)
        // {
        //     $("#modalFirstPart").modal('show');
        // }
    }

    $scope.mobileOverviewFilter = function(questIdx)
    {
        console.log(window.innerWidth);
        
        visible = false;
        if ($scope.activeQuestion < Math.ceil(maxBoxes/2))
        {
            visible = questIdx < maxBoxes;
        }else if($scope.activeQuestion > ($scope.questionaire.length - Math.ceil(maxBoxes/2))) 
        {
            visible = questIdx > $scope.questionaire.length - maxBoxes - 1;
        }else{
            visible = $scope.activeQuestion - questIdx < Math.ceil(maxBoxes/2) &&  questIdx- $scope.activeQuestion < Math.ceil(maxBoxes/2);
        }
        return visible;
    }

    $scope.submit = function(){
        let score = 0;
        $scope.questionaire.forEach(question => {
            if (question.type == "standard")
            {
                score += question.answer;
            }else {
                question.answers.forEach(answer => {
                    if (answer.selected)
                    {
                        score += answer.points;
                    }
                })
            }
        });
        $scope.score = score;

        $("#modalCheck").modal('show');
    }

    $scope.voteSpecial = function(question, id){
        question.answers.forEach(element => {
            if (element.id == id)
            {
                element.selected = true;
            }else{
                element.selected = false;
            }
        });
        question.selected = true;
    }

    $scope.questionaireFinished = function(){
        let solved = true;
        
        $scope.questionaire.forEach(question => {
            if(question.type == "standard")
            {
                if(question.answer == -1)
                {
                    solved = false;
                }
            }else{
                let selected = false;
                question.answers.forEach(answer => {
                    if (answer.selected)
                    {
                        selected = true;
                    }
                });

                if (!selected)
                {
                    solved = false;
                }
            }
        });
        
        if (solved&&$scope.mobile&&!$scope.scrolledIntoView)
        {
            document.getElementById("evaluateBtn").scrollIntoView();
            $scope.scrolledIntoView = true;
        }

        return solved;
    }

    $scope.reload = function()
    {
        $window.location.reload(); 
    }

    $scope.questionaire =
        [
            {
                "id": 1,
                "questionText": "Mir ist es wichtig zu wissen, was gerade angesagt ist. Ich will schließlich keinen Trend verpassen!",
                "type": "standard",
                "answer": -1,
                "selected": false
            },
            {
                "id": 2,
                "questionText": "Ich kaufe auch Sachen, die ich eigentlich nicht wirklich benötige.",
                "type": "standard",
                "answer": -1,
                "selected": false
            },
            {
                "id": 3,
                "questionText": "Wenn ich mir Kleidung kaufe, muss es Markenware sein.",
                "type": "standard",
                "answer": -1,
                "selected": false
            },
            {
                "id": 4,
                "questionText": "Wenn ich etwas Schönes im Laden sehe, kaufe ich es oft im Vorbeigehen, obwohl ich eigentlich kein Geld ausgeben wollte.",
                "type": "standard",
                "answer": -1,
                "selected": false
            },
            {
                "id": 5,
                "questionText": "Wenn ich auf etwas Größeres spare (z. B. ein Fahrrad), gebe ich mein Erspartes meistens trotzdem vorher für etwas anderes aus.",
                "type": "standard",
                "answer": -1,
                "selected": false
            },

            {
                "id": 6,
                "questionText": "Ich nehme mir meistens keine Zeit dafür, Produkte zu vergleichen – ich möchte schließlich nicht, dass mir jemand etwas vor der Nase wegschnappt!",
                "type": "standard",
                "answer": -1,
                "selected": false
            },
            {
                "id": 7,
                "questionText": "Ich folge in den Social Media (z. B. Instagram, TikTok) bekannten Influencerinnen und Influencern.",
                "type": "standard",
                "answer": -1,
                "selected": false
            },
            {
                "id": 8,
                "questionText": "Ich habe ein berühmtes Vorbild und versuche diesem nachzueifern.",
                "type": "standard",
                "answer": -1,
                "selected": false
            },
            {
                "id": 9,
                "questionText": "Wenn eine bekannte Person eine schöne Jacke trägt, möchte ich mir diese am liebsten auch sofort kaufen.",
                "type": "standard",
                "answer": -1,
                "selected": false
            },
            {
                "id": 10,
                "questionText": "Ich besitze etwas, das schon einmal von einer bekannten Person beworben wurde (z. B. Kleidung, Sonnenbrille, Schmuck).",
                "type": "standard",
                "answer": -1,
                "selected": false
            },

            {
                "id": 11,
                "questionText": "Wenn ich einkaufe, ist mir der Preis egal. Ich kaufe das, was ich möchte – und zwar sofort!",
                "type": "standard",
                "answer": -1,
                "selected": false
            },
            {
                "id": 12,
                "questionText": "Die Qualität eines Produktes ist nicht so wichtig – meistens verliere ich nach kurzer Zeit ohnehin das Interesse daran.",
                "type": "standard",
                "answer": -1,
                "selected": false
            },

            {
                "id": 13,
                "questionText": "Dein Lieblings-Influencer bewirbt in seinem neuen Video eine Hautcreme, die Pickel verhindern soll. Er ist ganz begeistert von dem Produkt und empfiehlt dir direkt den Kauf. Du weißt, dass der Influencer für diese Werbung bezahlt wurde, aber mit einem Gutscheincode sparst du sogar noch einmal 20 % ...",
                "type": "special",
                "answers": [
                    {
                        "id": 1,
                        "text": "Die Creme direkt zu bestellen kann nicht schlecht sein – nachher ist sie ausverkauft.",
                        "selected": false,
                        "points": 3
                    },
                    {
                        "id": 2,
                        "text": "Kosmetikprodukte sind sehr teuer – ich verzichte trotz seiner Empfehlung auf den Kauf.",
                        "selected": false,
                        "points": 1
                    },
                    {
                        "id": 3,
                        "text": "Die Creme ist doch schon längst wieder out. Es gibt einen ganz neuen Pickelstift auf dem Markt – den besorge ich mir.",
                        "selected": false,
                        "points": 5
                    }
                ],
                selected: false
            },
            {
                "id": 14,
                "questionText": "Auf dem Weg zum Friseur siehst du, dass im Schaufenster eine Hose im „Sale“ angeboten wird. Diese Hose wolltest du dir schon immer kaufen, aber bisher war sie zu teuer für dich. Leider reicht dein Geld nicht für die Hose und den Friseur ...",
                "type": "special",
                "answers": [
                    {
                        "id": 4,
                        "text": "Egal, ich kaufe schnell die Hose, bevor sie vergriffen ist.",
                        "selected": false,
                        "points": 3
                    },
                    {
                        "id": 5,
                        "text": "Ich entscheide mich für den Friseurbesuch – das hatte ich schließlich geplant. Vielleicht kaufe ich mir die Hose aber von meinem nächsten Taschengeld.",
                        "selected": false,
                        "points": 1
                    },
                    {
                        "id": 6,
                        "text": "Wenn sie jetzt schon im Sale ist, verzichte ich gerne auf die Hose – die ist dann sowieso bald nicht mehr angesagt.",
                        "selected": false,
                        "points": 5
                    }
                ],
                selected: false
            },
            {
                "id": 15,
                "questionText": "In der Zeitung wird Werbung für einen großen Wasserpark gemacht. Die Anzeige verspricht, dass der Park die längste Wasserrutsche Europas zu bieten hat und es dort sogar preisgekrönte Pommes frites gibt, die dir auf der Zunge zergehen. Außerdem ist dort eine Bühne aufgebaut, auf der regelmäßig Konzerte stattfinden.",
                "type": "special",
                "answers": [
                    {
                        "id": 7,
                        "text": "Das klingt doch super. Ich verabrede mich mit meinen Freunden und wir buchen die Tickets direkt über das Internet.",
                        "selected": false,
                        "points": 3
                    },
                    {
                        "id": 8,
                        "text": "Das klingt alles zu schön um wahr zu sein. Bestimmt verlangt der Park ein viel zu hohes Eintrittsgeld – das ist es mir nicht wert.",
                        "selected": false,
                        "points": 1
                    },
                    {
                        "id": 9,
                        "text": "Ich recherchiere, ob schon eine bekannte Person dort aufgetreten ist, sonst interessiert mich der Park nicht.",
                        "selected": false,
                        "points": 5
                    }
                ],
                selected: false
            }
        ]

});