package dreiecksrechner;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;

import javax.imageio.ImageIO;

/**
 * Model, das die Berechnungsmethoden fuer den Dreiecksrechner enthaelt
 */
public class DreiecksrechnerModel {

	//Konstanten der Instanz
	private final int RECHTER_WINKEL = 90;
	private final int WINKELSUMME = 180;

	/**
	 * Berechnet den Winkel Beta aus dem Winkel Alpha.
	 * @param Winkel Alpha als int
	 * @return Winkel Beta in Grad als int
	 */
	public int berechneWinkelBeta(int winkelAlpha) {		
		return WINKELSUMME - RECHTER_WINKEL - winkelAlpha;
	}

	/**
	 * Berechnet die Gegenkathete aus dem Winkel Alpha und der Hypothenuse.
	 * @param Winkel Alpha als int, Hypthenuse als int
	 * @return Laenge der Gegenkathete in mm als formatierten String
	 */
	public String berechneGegenkathete(int winkelAlpha, int hypothenuse) {		// Loesung
		//Grad in Radiant umwandeln
		double winkelAlphaRad = Math.PI*winkelAlpha/180;
		//Gegenkathete berechnen und zurueckgeben
		return NumberFormat.getInstance().format(Math.abs(Math.sin(winkelAlphaRad)*hypothenuse));
	}																			// Loesung
	
	/**
	 * Berechnet die Ankathete aus dem Winkel Alpha und der Hypothenuse.
	 * @param Winkel Alpha als int, Hypthenuse als int
	 * @return Laenge der Ankathete in mm als formatierten String
	 */
	public String berechneAnkathete(int winkelAlpha, int hypothenuse) {			// Loesung
		//Grad in Radiant umwandeln
		double winkelAlphaRad = Math.PI*winkelAlpha/180;
		//Ankathete berechnen und zurueckgeben
		return NumberFormat.getInstance().format((Math.cos(winkelAlphaRad)*hypothenuse));
	}																			// Loesung
	
	public Image liesBildEin(String bildPfad) {
		Image retImage = null;
		try {
			retImage = ImageIO.read(new File(bildPfad));
		} catch (IOException ioe) {
			System.out.println("Bild fehlt!");
		}
		return retImage;
	}
}
