package dreiecksrechner;

import java.awt.Image;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

/**
 * Model, das die Berechnungsmethoden fuer den Dreiecksrechner enthaelt
 */
public class DreiecksrechnerModel {

	//Konstanten der Instanz
	private final int RECHTER_WINKEL = 90;
	private final int WINKELSUMME = 180;

	/**
	 * Berechnet den Winkel Beta aus dem Winkel Alpha.
	 * @param Winkel Alpha als int
	 * @return Winkel Beta in Grad als int
	 */
	public int berechneWinkelBeta(int winkelAlpha) {		
		return WINKELSUMME - RECHTER_WINKEL - winkelAlpha;
	}

	public Image liesBildEin(String bildPfad) {
		Image retImage = null;
		try {
			retImage = ImageIO.read(new File(bildPfad));
		} catch (IOException ioe) {
			System.out.println("Bild fehlt!");
		}
		return retImage;
	}
}
