package muliplikationstabellen;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

/**
 * View-Klasse, die die Benutzeroberflaeche fuer die Ausgabe der Multiplikationstabellen bildet
 */
public class MultiplikationstabellenView extends JFrame {

	/*
	 * Hier nicht notwendig. Eingefuegt, um Warnmeldung der Entwicklungsumgebung zu vermeiden.
	 * Alternative: Deaktivieren der Warnmeldung
	 */
	private static final long serialVersionUID = 1L;

	// Instanzvariablen
	private MultiplikationstabellenController mController;
	private int[][] mTafel;
	private Image logo;
	private Font anzeigenFont;
	private Font multiplikatorFont;
	private TitledBorder eBorder;
	private TitledBorder aBorder;
	private String logoPath 			= "images/logo.jpg";
	private JPanel eaPanel 				= new JPanel();
	private JPanel ePanel 				= new JPanel();
	private JPanel aPanel 				= new JPanel();
	private JPanel logoPanel 			= new JPanel();
	private JScrollBar multiplikatorBar = new JScrollBar( Adjustable.HORIZONTAL, 1, 1, 1, 21);
	private JTextField multiplikator    = new JTextField( "" + multiplikatorBar.getValue(), 20 );
	private JButton anzeigenButton 	    = new JButton("Multiplikationstabelle anzeigen");
	private JTextPane tabellenPane      = new JTextPane();
	private JLabel logoLabel 			= new JLabel();
	
	// Konstruktor
	public MultiplikationstabellenView(MultiplikationstabellenController mController) {

		super("Anzeige von Multiplikationstabellen");
		this.mController = mController;

		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		// Groesse fuer JFrame setzen
		this.setSize(800, 900);
		// Hintergundfarben setzen
		this.setzeHintergrundfarben();
		// Layout fuer JFrame festlegen
		BorderLayout bdl = new BorderLayout();
		this.setLayout(bdl);
		this.add(eaPanel, BorderLayout.CENTER);
		this.add(logoPanel, BorderLayout.SOUTH);
		// Layout fuer eaPanel festlegen
		GridLayout eaGl = new GridLayout(2,1);
		eaPanel.setLayout(eaGl);
		eaPanel.add(ePanel);
		eaPanel.add(aPanel);
		// Rahmen fuer ePanel
		eBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.white), "Eingabe");
		ePanel.setBorder(eBorder);
		// Layout fuer ePanel festlegen
		GridLayout eGl = new GridLayout(3,1,20,20);
		ePanel.setLayout(eGl);
		ePanel.add(multiplikator);
		ePanel.add(multiplikatorBar);
		ePanel.add(anzeigenButton);
		
		// Rahmen fuer aPanel
		aBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.white), "Ausgabe");
		aPanel.setBorder(aBorder);   
		// Layout fuer aPanel festlegen
		GridLayout aGl = new GridLayout(1,1,20,20);					
		aPanel.setLayout(aGl);
		aPanel.add(tabellenPane);
		
		//Textfelder ausrichten
		this.richteTextfelderAus();									
		
		//Schriften setzen
		this.setzeFonts();
		
		if (this.liesImageEin(logoPath)!=null) {
			//Logo einlesen und als Icon zu JLabel hinzufuegen
			logo = this.liesImageEin(logoPath);
			Icon logoIcon = new ImageIcon(logo);
			logoLabel.setIcon(logoIcon);
			//Zu logoPanel hinzufuegen
			logoPanel.add(logoLabel);
		}
		
		// Hauptfenster anzeigen
		this.setVisible(true);

		// Actionlistener registrieren
		this.anzeigenButton.addActionListener(e -> zeigeMultiplikationstabelle());	
		this.multiplikatorBar.addAdjustmentListener(e -> multiplikator.setText(""+this.multiplikatorBar.getValue()));
	}
	
	public void zeigeMultiplikationstabelle() {
		mTafel=mController.holeMultiplikationstafel();
		int mWert = this.multiplikatorBar.getValue();
		String mTabellenString =new String();
		for(int i=0; i<mTafel.length;i++) {
			mTabellenString+=mWert+" * "+(i+1)+" = "+mTafel[mWert-1][i]+"\n";
		}
		tabellenPane.setText(mTabellenString);	
	}
	
	public Image liesImageEin(String imagePfad) {
		return mController.liesBildEin(imagePfad);
	}
	
	private void richteTextfelderAus() {								
		this.multiplikator.setHorizontalAlignment(JTextField.CENTER);
		SimpleAttributeSet mTPaneSet = new SimpleAttributeSet();
		StyleConstants.setAlignment(mTPaneSet,StyleConstants.ALIGN_CENTER);	
		this.tabellenPane.setParagraphAttributes(mTPaneSet, true);
	}																	
	
	public void setzeFonts() {
		this.multiplikatorFont = new Font(Font.SANS_SERIF, Font.PLAIN, 40);
		this.anzeigenFont = new Font(Font.SANS_SERIF, Font.PLAIN, 20);
		this.multiplikator.setFont(multiplikatorFont);
		this.multiplikator.setForeground(Color.black);
		this.multiplikatorBar.setFont(anzeigenFont);
		this.multiplikatorBar.setForeground(Color.black);
		this.tabellenPane.setFont(anzeigenFont);
		this.tabellenPane.setForeground(Color.black);
		this.logoLabel.setFont(anzeigenFont);
		this.eBorder.setTitleFont(anzeigenFont);
		this.eBorder.setTitleColor(Color.gray);
		this.aBorder.setTitleFont(anzeigenFont);
		this.aBorder.setTitleColor(Color.gray);
		this.anzeigenButton.setFont(anzeigenFont);
	}
	
	public void setzeHintergrundfarben() {
		this.setBackground(Color.black);
		eaPanel.setBackground(Color.black);
		logoPanel.setBackground(Color.black);
		ePanel.setBackground(Color.black);
		aPanel.setBackground(Color.black);
	}
}
