package dreiecksrechner;

import java.awt.Image;

/**
 * Controller-Klasse, die zusammen mit der Dreiecksrechner-Klasse die Verbindung zwischen View und Model bildet
 */
public class DreiecksrechnerController {
	
	private DreiecksrechnerModel dModel;
	private DreiecksrechnerView dView;

	/**
	 * @param dModel
	 * @param dView
	 */
	public DreiecksrechnerController(DreiecksrechnerModel dModel, DreiecksrechnerView dView) {
		this.dModel = dModel;
		this.dView = dView;
	}
	
	/**
	 * @param Winkel Alpha als int
	 * @return Winkel Beta als int
	 */
	public int berechneWinkelBeta(int winkelAlpha) {
		return dModel.berechneWinkelBeta(winkelAlpha);
	}
	
	/**
	 * @param Winkel Alpha als int, Hypothenuse als int
	 * @return Winkel Beta als int
	 */
	public Double berechneGegenkathete(int winkelAlpha, int hypothenuse) {	// Loesung
		return dModel.berechneGegenkathete(winkelAlpha, hypothenuse);
	}																		// Loesung
	
	/**
	 * @param Winkel Alpha als int, Hypothenuse als int
	 * @return Winkel Beta als int
	 */
	public Double berechneAnkathete(int winkelAlpha, int hypothenuse) {		// Loesung
		return dModel.berechneAnkathete(winkelAlpha, hypothenuse);
	}																		// Loesung
	
	/**
	 * @param Bild-Pfad als String
	 * @return Bild als Image
	 */
	public Image liesBildEin(String bildPfad) {
		return dModel.liesBildEin(bildPfad);
	}

}
