package dreiecksrechner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;

import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

/**
 * View-Klasse, die zusammen mit der DreiecksPanel-Klasse die Benutzeroberflaeche des Dreiecksrechners bildet
 */
public class DreiecksrechnerView extends JFrame {

	/*
	 * Hier nicht notwendig. Eingefuegt, um Warnmeldung der Entwicklungsumgebung zu vermeiden.
	 * Alternative: Deaktivieren der Warnmeldung
	 */
	private static final long serialVersionUID = 1L;

	// Instanzvariablen
	private DreiecksrechnerController dController;
	private Image logo;
	private Font font;
	private TitledBorder eBorder;
	private TitledBorder aBorder;
	private String logoPath 			= "images/logo.jpg";
	private DreiecksPanel dPanel 		= new DreiecksPanel();
	private JPanel eaPanel 				= new JPanel();
	private JPanel ePanel 				= new JPanel();
	private JPanel aPanel 				= new JPanel();
	private JPanel logoPanel 			= new JPanel();
	private JButton berechnenButton 	= new JButton("Berechnen");
	private JLabel hypothenuse 			= new JLabel("Hypothenuse:");
	private JLabel winkel1 			    = new JLabel("Winkel Alpha:");
	private JLabel winkel2 			    = new JLabel("Fehlender Winkel:");
	private JLabel gegenkathete 		= new JLabel("Seite 1:");			// Loesung
	private JLabel ankathete 			= new JLabel("Seite 2:");			// Loesung
	private JTextField hypothenuseTF 	= new JTextField();
	private JTextField winkelAlphaTF 	= new JTextField();
	private JTextField winkelBetaTF 	= new JTextField();
	private JTextField gegenkatheteTF 	= new JTextField();					// Loesung
	private JTextField ankatheteTF 		= new JTextField();					// Loesung
	private JLabel hypothenuseEinheit 	= new JLabel("mm");					// Loesung
	private JLabel winkelAlphaEinheit 	= new JLabel("°");					// Loesung
	private JLabel winkelBetaEinheit 	= new JLabel("°");					// Loesung
	private JLabel gegenkatheteEinheit 	= new JLabel("mm");					// Loesung
	private JLabel ankatheteEinheit 	= new JLabel("mm");					// Loesung
	private JLabel leererJLabel1 		= new JLabel("");					// Loesung
	private JLabel leererJLabel2 		= new JLabel("");	
	private JLabel leererJLabel3 		= new JLabel("");
	private JLabel leererJLabel4 		= new JLabel("");
	private JLabel leererJLabel5 		= new JLabel("");
	private JLabel leererJLabel6 		= new JLabel("");
	private JLabel leererJLabel7 		= new JLabel("");
	private JLabel leererJLabel8 		= new JLabel("");
	private JLabel logoLabel 			= new JLabel();
	private ButtonGroup butGruppe1 		= new ButtonGroup();
	private JRadioButton hypoBut        = new JRadioButton("Hypothenuse");
	private JRadioButton gegenkathBut   = new JRadioButton("Gegenkathete");
	private JRadioButton ankathBut      = new JRadioButton("Ankathete");
	private ButtonGroup butGruppe2 		= new ButtonGroup();
	private JRadioButton wAlphaBut      = new JRadioButton("Winkel Alpha");
	private JRadioButton wBetaBut       = new JRadioButton("Winkel Beta");
	

	
	// Konstruktor
	public DreiecksrechnerView(DreiecksrechnerController dController) {

		super("Dreiecksrechner für rechtwinklige Dreiecke");
		this.dController = dController;

		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		// Groesse für JFrame setzen
		this.setSize(800, 800);
		// Hintergundfarben setzen
		this.setzeHintergrundfarben();
		// Layout fuer JFrame festlegen
		BorderLayout bdl = new BorderLayout();
		this.setLayout(bdl);
		this.add(dPanel, BorderLayout.NORTH);
		this.add(eaPanel, BorderLayout.CENTER);
		this.add(logoPanel, BorderLayout.SOUTH);
		// Layout fuer eaPanel festlegen
		GridLayout eaGl = new GridLayout(2,1);
		eaPanel.setLayout(eaGl);
		eaPanel.add(ePanel);
		eaPanel.add(aPanel);
		// Rahmen fuer ePanel
		eBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.white), "Eingabe");
		ePanel.setBorder(eBorder);
		// Layout fuer ePanel festlegen
		GridLayout eGl = new GridLayout(5,3,20,20);
		ePanel.setLayout(eGl);
		ePanel.add(hypoBut);
		ePanel.add(hypothenuseTF);
		ePanel.add(hypothenuseEinheit);	
		ePanel.add(gegenkathBut);
		ePanel.add(leererJLabel1);
		ePanel.add(leererJLabel2);
		ePanel.add(ankathBut);
		ePanel.add(leererJLabel3);
		ePanel.add(leererJLabel4);
		ePanel.add(wAlphaBut);
		ePanel.add(winkelAlphaTF);
		ePanel.add(winkelAlphaEinheit);	
		ePanel.add(wBetaBut);
		ePanel.add(leererJLabel5);
		ePanel.add(leererJLabel6);
		butGruppe1.add(hypoBut);
		butGruppe1.add(gegenkathBut);
		butGruppe1.add(ankathBut);
		butGruppe2.add(wAlphaBut);
		butGruppe2.add(wBetaBut);
		
		// Rahmen fuer aPanel
		aBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.white), "Ausgabe");
		aPanel.setBorder(aBorder);   
		// Layout fuer aPanel festlegen
		GridLayout aGl = new GridLayout(4,3,20,20);					// Loesung
		aPanel.setLayout(aGl);
		aPanel.add(winkel2);
		aPanel.add(winkelBetaTF);
		aPanel.add(winkelBetaEinheit);								// Loesung
		aPanel.add(gegenkathete);									// Loesung
		aPanel.add(gegenkatheteTF);									// Loesung
		aPanel.add(gegenkatheteEinheit);							// Loesung
		aPanel.add(ankathete);										// Loesung
		aPanel.add(ankatheteTF);									// Loesung
		aPanel.add(ankatheteEinheit);								// Loesung
		aPanel.add(berechnenButton);
		//Leere JLabel werden nur eingefuegt, damit die Anordnung korrekt ist.
		aPanel.add(leererJLabel7);
		aPanel.add(leererJLabel8);									// Loesung
		
		//Textfelder ausrichten
		this.richteTextfelderAus();									// Loesung
		
		//Schriften setzen
		this.setzeFonts();
		
		if (this.liesImageEin(logoPath)!=null) {
			//Logo einlesen und als Icon zu JLabel hinzufuegen
			logo = this.liesImageEin(logoPath);
			Icon logoIcon = new ImageIcon(logo);
			logoLabel.setIcon(logoIcon);
			//Zu logoPanel hinzufuegen
			logoPanel.add(logoLabel);
		}
		
		// Hauptfenster anzeigen
		this.setVisible(true);

		// Actionlistener registrieren
		berechnenButton.addActionListener(e -> berechneUndZeigeErgebnisse(hypothenuseTF.getText(), winkelAlphaTF.getText()));		
	}
	
	public void berechneUndZeigeErgebnisse(String hypothenuse, String winkelAlpha) {
		int wAlpha = Integer.parseInt(winkelAlpha);
		int hypo = Integer.parseInt(hypothenuse);
		this.winkelBetaTF.setText(Integer.toString(dController.berechneWinkelBeta(wAlpha)));
		this.gegenkatheteTF.setText(NumberFormat.getInstance().format(dController.berechneGegenkathete(wAlpha, hypo)));  	// Loesung
		this.ankatheteTF.setText(NumberFormat.getInstance().format(dController.berechneAnkathete(wAlpha, hypo)));			// Loesung
	}
	
	public Image liesImageEin(String imagePfad) {
		return dController.liesBildEin(imagePfad);
	}
	
	private void richteTextfelderAus() {								// Loesung
		this.hypothenuseTF.setHorizontalAlignment(JTextField.RIGHT);
		this.winkelAlphaTF.setHorizontalAlignment(JTextField.RIGHT);
		this.winkelBetaTF.setHorizontalAlignment(JTextField.RIGHT);
		this.gegenkatheteTF.setHorizontalAlignment(JTextField.RIGHT);
		this.ankatheteTF.setHorizontalAlignment(JTextField.RIGHT);
	}																	// Loesung
	
	public void setzeFonts() {
		font = new Font(Font.SANS_SERIF, Font.PLAIN, 20);
		this.hypothenuse.setFont(font);
		this.hypothenuse.setForeground(Color.white);
		this.winkel1.setFont(font);
		this.winkel1.setForeground(Color.white);
		this.winkel2.setFont(font);
		this.winkel2.setForeground(Color.white);
		this.gegenkathete.setFont(font);								// Loesung
		this.gegenkathete.setForeground(Color.white);					// Loesung
		this.ankathete.setFont(font);									// Loesung
		this.ankathete.setForeground(Color.white);						// Loesung
		this.hypothenuseTF.setFont(font);
		this.winkelAlphaTF.setFont(font);
		this.winkelBetaTF.setFont(font);
		this.gegenkatheteTF.setFont(font); 								// Loesung
		this.ankatheteTF.setFont(font);									// Loesung
		this.hypothenuseEinheit.setFont(font);
		this.hypothenuseEinheit.setForeground(Color.white);
		this.winkelAlphaEinheit.setFont(font);
		this.winkelAlphaEinheit.setForeground(Color.white);
		this.winkelBetaEinheit.setFont(font);
		this.winkelBetaEinheit.setForeground(Color.white);
		this.gegenkatheteEinheit.setFont(font);							// Loesung
		this.gegenkatheteEinheit.setForeground(Color.white);			// Loesung
		this.ankatheteEinheit.setFont(font);							// Loesung
		this.ankatheteEinheit.setForeground(Color.white);				// Loesung
		this.logoLabel.setFont(font);
		this.winkelBetaEinheit.setFont(font);
		this.eBorder.setTitleFont(font);
		this.eBorder.setTitleColor(Color.gray);
		this.aBorder.setTitleFont(font);
		this.aBorder.setTitleColor(Color.gray);
		this.berechnenButton.setFont(font);
	}
	
	public void setzeHintergrundfarben() {
		this.setBackground(Color.black);
		dPanel.setBackground(Color.black);
		eaPanel.setBackground(Color.black);
		logoPanel.setBackground(Color.black);
		ePanel.setBackground(Color.black);
		aPanel.setBackground(Color.black);
	}
}
