package bahnhoefeMitCSV;

/**
 * Model zum Einlesen von CSV-Dateien
 */
public class BahnhoefeCSVModel extends BahnhoefeModel { 

	// Dummy-Daten, die die eigentlichen aus der Oberklasse geerbten Variablen verdecken
	String[] bahnhoefeColumnNames = {"EVA_NR","DS100","IFOPT","NAME","Verkehr","Laenge","Breite","Betreiber_Name","Betreiber_Nr","Status"};
	String[] [] bahnhoefeData = {	{"8002551","AELB","de:02000:11943","Hamburg Elbbrücken","RV","10,0245","53,5345","DB Station und Service AG","","neu"},
									{"8001944","TETN","","Eutingen Nord","RV","8,7531","48,4847","DB Station und Service AG","","neu"},
									{"8003074","MIA","","Ingolstadt Audi","RV","11,4074564","48,7904959","DB Station und Service AG","","neu"},
									{"8001723","HEBA","","Einbeck Otto-Hahn-Straße","RV","9,89290953","51,8144784","Ilmebahn GmbH","","neu"},
									{"8004371","KRO","","Nörvenich-Rommelsheim","nur DPN","6,547586","50,782539","Rurtalbahn GmbH","","neu"},
									{"8010340","DSTR","","Straßgräbchen-Bernsdorf","nur DPN","14,052047","51,361469","","","neu"},
									{"8001510","TDSA","de:08237:8009:2","Dornstetten-Aach","RV","8,48291","48,4733","DB Station und Service AG","","neu"},
									{"8001966","MFOL","de:09187:90183","Feldolling","nur DPN","11,852244","47,895336","DB Station und Service AG","","neu"}	  };
	
	@Override
	public void liesBahnhoefeDaten() {
		
		// Zuweisung der Instanzvariablen mit den Dummy-Daten zu den Variablen der Oberklasse, da diese vom Controller gelesen werden.
		super.bahnhoefeColumnNames = this.bahnhoefeColumnNames;
		super.bahnhoefeData        = this.bahnhoefeData;
		
		/* Hier muss der Zugriff auf die CSV-Datei programmiert werden.
		 * Die Daten aus der CSV-Datei sollen den den obenstehenden Variablen bahnhoefeData und bahnhoefeColumnNames anstatt der Dummy-Daten zugewiesen werden.
		 */
		
	}

}
