package bahnhoefeMitDB;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

/**
 * Abstrakte Model-Klasse, die die abstrakte Methode liesBahnhoefeDaten() enthaelt, die in den Unterklassen entsprechend implementiert werden muss
 */
public abstract class BahnhoefeModel {
	
	protected int zeilenAnzahl = 0;
	protected String[] bahnhoefeColumnNames; 
	protected String[][] bahnhoefeData; 

	/**
	 * @return the bahnhoefeColumnNames
	 */
	public String[] getBahnhoefeColumnNames() {
		return bahnhoefeColumnNames;
	}

	/**
	 * @param bahnhoefeColumnNames the bahnhoefeColumnNames to set
	 */
	public void setbahnhoefeColumnNames(String[] bahnhoefeColumnNames) {
		this.bahnhoefeColumnNames = bahnhoefeColumnNames;
	}

	/**
	 * @return the bahnhoefeData
	 */
	public String[][] getBahnhoefeData() {
		return bahnhoefeData;
	}

	
	public void setbahnhoefeData(String[][] bahnhoefeData) {
		this.bahnhoefeData = bahnhoefeData;
	}

	/**
	 * Methode zum Einlesen der Daten zu den Bahnhoefen
	 */
	public abstract void liesBahnhoefeDaten();
	
}
