package bahnhoefeMitDB;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

/**
 * Einfache Benutzeroberflaeche mit JTable zum Anzeigen der Daten
 */
public class BahnhoefeView {

	// Instanzvariablen
	private BahnhoefeController bController;
	private String[] datenquellen = {"CSV-Datei", "Datenbank"};	// Loesung
	String[] columnNames;
	String[][] tableData;
	private JFrame bFrame = new JFrame();
	JTable table;
	private JPanel northPanel = new JPanel();
	private JButton einlesenButton = new JButton("Daten einlesen");
	private JButton beendenButton = new JButton("beenden");
	private JLabel datenLabel = new JLabel("Datenquelle:");
	private JComboBox<String> datenComboBox = new JComboBox<String> (datenquellen);	// Loesung
	private TableRowSorter<TableModel> sorter;

	public BahnhoefeView(BahnhoefeController bController) {
		this.bController = bController;
		bFrame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
		this.holeTableDaten();
		this.erneuereJTable();
		
		// Layout festlegen
		BorderLayout bdl = new BorderLayout();
		bFrame.setLayout(bdl);
		bFrame.add(northPanel, BorderLayout.NORTH);
		bFrame.add(new JScrollPane(table), BorderLayout.CENTER);
		bFrame.add(beendenButton, BorderLayout.SOUTH);
		GridLayout glNorth = new GridLayout(1,3);
		northPanel.setLayout(glNorth);
		northPanel.add(einlesenButton);
		northPanel.add(datenLabel);
		northPanel.add(datenComboBox);	// Loesung
		
		//Sortierung
		sorter = new TableRowSorter<TableModel>(table.getModel());
		table.setRowSorter(sorter);

		// Hauptfenster anzeigen
		bFrame.setSize(1600,800);
		bFrame.setVisible(true);

		// Actionlistener registrieren
		einlesenButton.addActionListener(e -> liesDatenEin());
		beendenButton.addActionListener(e -> System.exit(0));
		datenComboBox.addActionListener(e -> setzeDatenquelle());	// Loesung
		table.getModel().addTableModelListener(table);
	}

	private void liesDatenEin() {
		bController.erneuereBahnhofDaten();
		this.holeTableDaten();
	}
	
	private void setzeDatenquelle() {	// Loesung
		if (datenComboBox.getSelectedIndex()==0) {
			bController.setbModel(new BahnhoefeCSVModel());
		}
		else if (datenComboBox.getSelectedIndex()==1) {
			bController.setbModel(new BahnhoefeDBModel());
		}
		bController.erneuereBahnhofDaten();
	}									//Loesung

	private void holeTableDaten() {
		tableData = bController.getTableData();
		columnNames = bController.getColumnNames();	
		erneuereJTable();
	}
	
	private void erneuereJTable() {
		if(table!=null) {
			bFrame.remove(table);
		}
		table = new JTable(tableData, columnNames);
		bFrame.add(table , BorderLayout.CENTER);
		bFrame.setVisible(true);
	}
}


