package bahnhoefeMitDB;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

/**
 * Model zum Einlesen von CSV-Dateien
 */
public class BahnhoefeCSVModel extends BahnhoefeModel {

	String[][] bahnhoefeDatenAusCSV;
	
	@Override
	public void liesBahnhoefeDaten() {
		int i = 0;
		zeilenAnzahl = 0;
		int spaltenAnzahl = 0;

		System.out.println("CSV");
		// Anzahl der Zeilen für das aeussere Array 
		try (BufferedReader in = Files.newBufferedReader(Paths.get(BahnhoefeLauncher.getQuellenInfoCsv()), StandardCharsets.UTF_8)) {
			in.lines().forEach(l -> zeilenAnzahl++);
		}
		catch (IOException ioe) {
			System.out.println("Bahnhof-Datei nicht vorhanden.");
		}
		// Anzahl der Spalten für das innere Array 
		try (BufferedReader in = Files.newBufferedReader(Paths.get(BahnhoefeLauncher.getQuellenInfoCsv()), StandardCharsets.UTF_8)) {
			String line = in.readLine();
			String[] kopfzeile = line.split(";");
			spaltenAnzahl = kopfzeile.length;
			bahnhoefeDatenAusCSV = new String[zeilenAnzahl][spaltenAnzahl];
		}
		catch (IOException ioe) {
			System.out.println("Bahnhof-Datei nicht vorhanden.");
		}
		try (BufferedReader in = Files.newBufferedReader(Paths.get(BahnhoefeLauncher.getQuellenInfoCsv()), StandardCharsets.UTF_8)) {
			for ( String line; (line = in.readLine()) != null; i++) {
				String[][] tempDatenAusCSV = new String[zeilenAnzahl][];
				tempDatenAusCSV[i] = line.split(";");
				for(int j=0; j<spaltenAnzahl; j++) {
					/* Korrektur der Groesse des Arrays tempDatenAusCsv auf die Anzahl der Spalten der Kopfzeile, 
					 * falls es in der aktuellen Zeile keinen Eintrag nach dem letzten Strichpunkt gibt,
					 * damit die Daten in der JTable dargestellt werden koennen.
					 */
					if(tempDatenAusCSV[i].length<=j) {
						bahnhoefeDatenAusCSV[i][j] = "";
						continue;
					}
					bahnhoefeDatenAusCSV[i][j] = tempDatenAusCSV[i][j];
				}
			}
		}
		catch (IOException ioe) {
			System.out.println("Bahnhof-Datei nicht vorhanden.");
		}
		//Trennen der Spaltenbezeichnungen und der Daten
		bahnhoefeData = new String[zeilenAnzahl-1][];
		bahnhoefeColumnNames = bahnhoefeDatenAusCSV[0];
		for (int j=1; j<bahnhoefeDatenAusCSV.length; j++) {
			bahnhoefeData[j-1] = bahnhoefeDatenAusCSV[j];
		}
	}

}
