package bahnhoefeMitDB;

import java.io.File;

/**
 * Klasse zum Starten des Programmes
 * Kann als zum Controller-Teil gehoerige Klasse angesehen werden. 
 */
public class BahnhoefeLauncher {

	private static final String DB_Treiber = "org.mariadb.jdbc.Driver";	// Loesung
	private static final String QUELLEN_INFO_CSV = "data"+File.separator+"D_Bahnhof_2020_alle.csv";	
	private static final String QUELLEN_DB = "jdbc:mariadb://localhost:3306/testdb?user=root&password=";	// Loesung

	private BahnhoefeModel bModel;
	private BahnhoefeController bController;
	private BahnhoefeView bView;

	public BahnhoefeLauncher()  {
		this.bModel = new BahnhoefeCSVModel();  //Damit zu Beginn aus der Datenbank gelesen wird, BahnhoefeCSVModel() durch BahnhoefeDBModel() ersetzen.
		this.bController = new BahnhoefeController(bModel) ;
		this.bView = new BahnhoefeView(bController);	
	}

	/**
	 * @return the dbTreiber
	 */
	public static String getDbTreiber() {
		return DB_Treiber;
	}

	/**
	 * @return the quellenInfoCsv
	 */
	public static String getQuellenInfoCsv() {
		return QUELLEN_INFO_CSV;
	}

	/**
	 * @return the quellenDb
	 */
	public static String getQuellenDb() {
		return QUELLEN_DB;
	}



	public static void main( String[] args )  {
		new BahnhoefeLauncher();
	}

}
