import sympy as sp
import numpy as np
import matplotlib.pyplot as plt

# SymPy:
sp.init_printing(use_unicode=True)
x = sp.symbols('x')
expression = 5*x**3 + 3*x - 42
first_deriv = sp.diff(expression,x,1)
second_deriv = sp.diff(first_deriv,x,1)

# NumPy:
x_vals = np.linspace(-5,5)

# Kombination sympy+numpy:
f = sp.lambdify(x,expression,"numpy")
fderiv1 = sp.lambdify(x,first_deriv,"numpy")
fderiv2 = sp.lambdify(x,second_deriv,"numpy")

# Für die Nachwelt:
plt.plot(x_vals, f(x_vals), label="f")
plt.plot(x_vals, fderiv1(x_vals), label="f'")
plt.plot(x_vals, fderiv2(x_vals), label="f''")
plt.legend()

plt.show()
