# Programmierkurs Python
# 
# Autor: Dominik Göddeke, IANS, Universität Stuttgart
#
# Veröffentlicht auf www.zoerr.de unter der CC-BY Lizenz
# https://creativecommons.org/licenses/by/4.0/ 

# Die Matrix wird in numpy offenbar als Menge von "gestapelten" Zeilenvektoren definiert.
# Das nennt man "row-major", der Zeilenindex hat Vorrang vor dem Spaltenindex,
# und im Moment ist das nur relevant, um zu verstehen, wie die konkreten Zahlwerte 
# in Python eingegeben werden.

import numpy as np

A = np.array([ [1, 2, 3], [4, 1, 6], [7, 1, 9] ])

# Für ein lineares Gleichungssystem benötigen wir noch eine rechte Seite, 
# als Vektor wird dies genau so definiert wie die Matrix:
b = np.array( [10, 11, 12])

# Nun lösen wir das lineare Gleichungssystem:
x = np.linalg.solve(A,b)

# Wir geben das Ergebnis aus:
print(x)

# Wir überzeugen uns von der Korrektheit des Ergebnisses, indem wir Ax-b ausrechnen
# lassen. Wenn x die Lösung ist, sollte das Ergebnis der Nullvektor sein.
# Die Syntax für das Matrix-Vektor Produkt erklären wir in einer späteren Einheit
print("Probe:")
print(A.dot(x)-b)

